% drop degree variables

clear 
addpath('Routines')
addpath('Powell')

logfile_name=[mfilename '.log'];
result_name=[mfilename '_results'];
delete(logfile_name);
diary(logfile_name);


load('NLSY.mat')

diary on
summstats(dat,varnames)
diary off


% Sample selection: Women
female=getvariables(dat,varnames,{'female'});
dat=dat(female==1,:);
n=size(dat,1);
% 

female=getvariables(dat,varnames,{'female'});
year=getvariables(dat,varnames,{'year'});
ID=getvariables(dat,varnames,{'ID'});


x1names={'children' 'married' 'sp_inc4'};
x1=getvariables(dat,varnames,x1names);

% create time dummies. Last one excluded
T1=min(year);
T2=max(year);
yr_names={};
tdummies=zeros(n,T2-T1);

for t=T1:T2-1
    tmp=['yr' num2str(t)];
    yr_names=cat(2,yr_names, {tmp});
    tdummies(:,t-T1+1)=(year==t);
end
summstats(tdummies,yr_names)
    
yname={'empl'};
y=getvariables(dat,varnames,yname);


% create nn 
% data for individual iobs is in rows nn(iobs,1) to nn(iobs,2)

IDs=unique(ID);
nobs=length(IDs);
nn=zeros(nobs,2);
nn(1,1)=1;
iobs=1;
for i=2:n
    if ID(i)~=ID(i-1)
        nn(iobs,2)=i-1;
        iobs=iobs+1;
        nn(iobs,1)=i;
    end
end
nn(iobs,2)=n;
if iobs~=nobs
    fprintf('something is wrong with panel structure')
end

y_lag1=zeros(n,1)+NaN;
for i=2:n
    if (ID(i)==ID(i-1)) && (year(i)==(year(i-1)+1))
        y_lag1(i)=y(i-1);
    end
end

y_lag2=zeros(n,1)+NaN;
for i=3:n
    if (ID(i)==ID(i-2)) && (year(i)==(year(i-2)+2))
        y_lag2(i)=y(i-2);
    end
end



% logit ignoring fixed effects
yy=y;
xx=[ones(n,1) y_lag1 y_lag2 x1 tdummies(:,3:size(tdummies,2))];
xxnames=cat(2,{'const.' 'L.y' 'L2.y'},cat(2,x1names,yr_names(3:length(yr_names))));

% get rid of ones without a lag
ii=find(~isnan(y_lag1) & ~isnan(y_lag2));
yy=yy(ii);
xx=xx(ii,:);
IIDD=ID(ii);

[blogit,slogit,f,H,V,scores]=estimate_logit(yy,xx);
cnames={'estimate' 'st.err.'};
Title='Logit';
diary on
write_res([blogit slogit],xxnames,cnames,Title,nobs)
diary off



IIDDs=unique(IIDD);
nobs1=length(IIDDs);
nn1=zeros(nobs1,2);
nn1(1,1)=1;
iobs=1;
for i=2:length(IIDD)
    if IIDD(i)~=IIDD(i-1)
        nn1(iobs,2)=i-1;
        iobs=iobs+1;
        nn1(iobs,1)=i;
    end
end
nn1(iobs,2)=length(IIDDs);
if iobs~=nobs1
    fprintf('\n something is wrong with panel structure\n')
end

xx1=xx(:,2:size(xx,2));
xx1names=cat(2,{'L.y' 'L2.y'},cat(2,x1names,yr_names(3:length(yr_names))));
print=true;
[blogit_FE0,slogit_FE0,fval,H,V,scores]=estimate_logit_FE(yy,xx1,nn1,blogit,1,print);

% Bootstrap
nboot=1000;
bbhat=zeros(nboot,length(blogit_FE0));
print=false;
rng(0,'twister');
for ib=1:nboot
    ib
    indx=randi([1 nobs1],nobs1,1);
    xxb=[];
    yyb=[];
    nnb=zeros(nobs1,2);
    nnb(1,1)=1;
    for i=1:nobs1
        iii=nn1(indx(i),1):nn1(indx(i),2);
        nnb(i,2)=nnb(i,1)+length(iii)-1;
        if i<nobs1
            nnb(i+1,1)=nnb(i,2)+1;
        end
        xxb=[xxb;xx1(iii,:)];
        yyb=[yyb;yy(iii,:)];
    end
    [bb,ss,fval,H,V,scores]=estimate_logit_FE(yyb,xxb,nnb,blogit,1,print);
    bbhat(ib,:)=bb';
end
slogit_FE0=iqr(bbhat)'/1.34;
            
    


cnames={'estimate' 'st.err. '};
Title='Logit Estimated FE 0';
diary on
write_res([blogit_FE0 slogit_FE0],xx1names,cnames,Title,nobs)
diary off

%  Going back to the original data

yy=y;
xx=[x1 tdummies(:,3:size(tdummies,2))];
xxnames=cat(2,x1names,yr_names(3:length(yr_names)));



% SCALING
xx(:,1)=xx(:,1)/2;
xx(:,3)=xx(:,3)/10;

% Find the sequences with 6 consequitive obs
IIkeep=zeros(length(ID),1);
j=0;
for i=6:length(ID)
    keepi=true;
    for i1=1:5
        if ID(i)~=ID(i-i1)
            keepi=false;
        end
    end
    for i1=0:5
        if isnan(i-i1)
            keepi=false;
        end
    end
    if keepi
        j=j+1;
        IIkeep(j)=i;
    end
end
IIkeep=IIkeep(1:j);

% create data for GMM

k=size(xx,2);
nkeep=length(IIkeep);
yB=yy(IIkeep-5);
yA=yy(IIkeep-4);
y1=yy(IIkeep-3);
y2=yy(IIkeep-2);
y3=yy(IIkeep-1);
y4=yy(IIkeep-0);

xB=xx(IIkeep-5,:);
xA=xx(IIkeep-4,:);
x1=xx(IIkeep-3,:);
x2=xx(IIkeep-2,:);
x3=xx(IIkeep-1,:);
x4=xx(IIkeep-0,:);
IDkeep=ID(IIkeep);

n=length(IDkeep);
nobs=length(unique(IDkeep));
nn=zeros(nobs,2);
nn(1,1)=1;
iobs=1;
for i=2:n
    if IDkeep(i)~=IDkeep(i-1)
        nn(iobs,2)=i-1;
        iobs=iobs+1;
        nn(iobs,1)=i;
    end
end
nn(iobs,2)=n;
if iobs~=nobs
    fprintf('something is wrong with panel structure\n\n')
end

should_scale=1;
[m,S]=moments(yB,yA,y1,y2,y3,y4,xB,xA,x1,x2,x3,x4,blogit(2:length(blogit)),should_scale);
a=(1./diag(S));
a((a==Inf))=0;
W0=diag(a);
[bGMM, fval]=estimate_GMM(yB,yA,y1,y2,y3,y4,xB,xA,x1,x2,x3,x4,0*blogit(2:length(blogit)),W0,true,should_scale,1);



% Bootstrap
nboot=1000;
bbhat=zeros(nboot,length(bGMM));
print=false;
rng(0,'twister');
for ib=1:nboot
    pri(ib)
    tic
    indx=randi([1 nobs],nobs,1);
    ii=[];
    for i=1:nobs
        ii=[ii;(nn(indx(i),1):nn(indx(i),2))'];
    end
    
    should_scale=1;
    [m,S]=moments(yB(ii),yA(ii),y1(ii),y2(ii),y3(ii),y4(ii),xB(ii,:),xA(ii,:),x1(ii,:),x2(ii,:),x3(ii,:),x4(ii,:),blogit(2:length(blogit)),should_scale);
    a=(1./diag(S));
    a((a==Inf))=0;
    W0=diag(a);
    [bb, fval]=estimate_GMM(yB(ii),yA(ii),y1(ii),y2(ii),y3(ii),y4(ii),xB(ii,:),xA(ii,:),x1(ii,:),x2(ii,:),x3(ii,:),x4(ii,:),bGMM,W0,false,should_scale);


    bbhat(ib,:)=bb';
    toc
end
sGMM=iqr(bbhat)'/1.3490;

% SCALING
bGMM(2)=bGMM(1)/2;
bGMM(4)=bGMM(3)/10;
sGMM(2)=sGMM(1)/2;
sGMM(4)=sGMM(3)/10;
cnames={'estimate' 'st.err.'};
Title='GMM Estimation (b_start=Logit MLE)';
diary on
write_res([bGMM sGMM],xx1names,cnames,Title,nobs)
fprintf('\nFunction Value (fminunc)  %g\n\n',nobs*fval)
diary off
save(result_name);

